<div id="tx-comments" data-fetch-url="{{ $fetchUrl }}" data-post-url="{{ $postUrl }}">
    <label class="control-label">@lang('lang_v1.additional_notes'):</label>
    <div id="tx-comments-list" class="well well-sm" style="max-height: 260px; overflow:auto; background:#fff;">
        <div class="text-muted">@lang('lang_v1.loading')...</div>
    </div>
    @if(!empty($postUrl))
    <div class="input-group" style="margin-top:8px;">
        <textarea id="tx-new-comment" class="form-control" rows="2" placeholder="@lang('lang_v1.add_a_comment')"></textarea>
        <span class="input-group-btn">
            <button id="tx-post-comment" class="btn btn-primary" type="button">@lang('messages.post')</button>
        </span>
    </div>
    @endif
</div>
<script>
(function(){
    var $box = $('#tx-comments');
    if(!$box.length) return;
    var fetchUrl = $box.data('fetch-url');
    var postUrl = $box.data('post-url');
    var $list = $('#tx-comments-list');
    function esc(s){
        return (s==null?'':String(s))
            .replace(/&/g,'&amp;')
            .replace(/</g,'&lt;')
            .replace(/>/g,'&gt;');
    }
    function render(items){
        if(!items || !items.length){ $list.html('<div class="text-muted">@lang("lang_v1.no_comments_yet")</div>'); return; }
        var html = '';
        items.forEach(function(it){
            var when = (it.created_at || '').replace('T',' ').replace('Z','');
            var who = (it.user_first_name||'') + (it.user_role?(' &bull; '+it.user_role):'');
            html += '<div style="padding:6px 8px; border-bottom:1px solid #eee;">'
                 + '<div style="font-weight:600">'+esc(who)+'</div>'
                 + '<div style="white-space:pre-wrap">'+esc(it.comment||'')+'</div>'
                 + '<div class="text-muted" style="font-size:12px">'+esc(when)+'</div>'
                 + '</div>';
        });
        $list.html(html);
    }
    $.get(fetchUrl, function(data){ render(data); }).fail(function(){
        $list.html('<div class="text-muted">@lang("lang_v1.no_comments_yet")</div>');
    });
    $('#tx-post-comment').on('click', function(){
        var text = ($('#tx-new-comment').val()||'').trim();
        if(!text) return;
        var token = (document.querySelector('meta[name="csrf-token"]')||{}).getAttribute ? document.querySelector('meta[name="csrf-token"]').getAttribute('content') : '';
        if(!token){ token = '{{ csrf_token() }}'; }
        $.post(postUrl, {comment: text, _token: token}, function(){
            $('#tx-new-comment').val('');
            $.get(fetchUrl, function(data){ render(data); });
        });
    });
})();
</script>


